
library(memisc)


library(mclogit)


load("model-cathprot-prayer-galtan-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_galtan <- mtable(model_galtan,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "GAL--TAN" = c("Squared" = "galtan.sq",                        
                                                "Linear"  = "galtan",                           
                                                "$\\times$ Protestant"     = "galtan:cathprotProtestant",
                                                "$\\times$ prays rarely"   = "galtan:prayRarely",
                                                "$\\times$ prays monthly"  = "galtan:prayMonthly",
                                                "$\\times$ prays weekly"   = "galtan:prayWeekly",
                                                "$\\times$ prays daily"    = "galtan:prayDaily",
                                                "$\\times$ Protestant $\\times$ prays rarely"   = "galtan:cathprotProtestant:prayRarely",
                                                "$\\times$ Protestant $\\times$ prays monthly"  = "galtan:cathprotProtestant:prayMonthly",
                                                "$\\times$ Protestant $\\times$ prays weekly"   = "galtan:cathprotProtestant:prayWeekly",
                                                "$\\times$ Protestant $\\times$ prays daily"    = "galtan:cathprotProtestant:prayDaily",
                                                "$\\times$ self-employed"  = "galtan:oesch8Self-employed",       
                                                "$\\times$ technical"      = "galtan:oesch8Technical",           
                                                "$\\times$ management"     = "galtan:oesch8Management",          
                                                "$\\times$ clerks"         = "galtan:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "galtan:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "galtan:oesch8Service worker",      
                                                "$\\times$ primary sector" = "galtan:oesch8Primary sector",      
                                                "$\\times$ denominational balance"       = "galtan:Cath_Prot",
                                                "$\\times$ denominational heterogeneity" = "galtan:Denom_Het",
                                                "$\\times$ time" = "galtan:time", 
                                                "$\\times$ Protestant     $\\times$ time"  = "galtan:cathprotProtestant",
                                                "$\\times$ prays rarely   $\\times$ time"  = "galtan:prayRarely:time",
                                                "$\\times$ prays monthly  $\\times$ time"  = "galtan:prayMonthly:time",
                                                "$\\times$ prays weekly   $\\times$ time"  = "galtan:prayWeekly:time",
                                                "$\\times$ prays daily    $\\times$ time"  = "galtan:prayDaily:time",
                                                "$\\times$ Protestant     $\\times$ prays rarely   $\\times$ time"  = "galtan:prayRarely:time",
                                                "$\\times$ Protestant     $\\times$ prays monthly  $\\times$ time"  = "galtan:prayMonthly:time",
                                                "$\\times$ Protestant     $\\times$ prays weekly   $\\times$ time"  = "galtan:prayWeekly:time",
                                                "$\\times$ Protestant     $\\times$ prays daily    $\\times$ time"  = "galtan:prayDaily:time",
                                                "$\\times$ self-employed  $\\times$ time"  = "galtan:time:oesch8Self-employed",  
                                                "$\\times$ technical      $\\times$ time"  = "galtan:time:oesch8Technical",      
                                                "$\\times$ management     $\\times$ time"  = "galtan:time:oesch8Management",     
                                                "$\\times$ clerks         $\\times$ time"  = "galtan:time:oesch8Clerks",         
                                                "$\\times$ socio-cultural $\\times$ time"  = "galtan:time:oesch8Socio-cultural", 
                                                "$\\times$ service worker $\\times$ time"  = "galtan:time:oesch8Service worker", 
                                                "$\\times$ primary sector $\\times$ time"  = "galtan:time:oesch8Primary sector"),                                  
                            "Econ Left--Right"= c("Squared" = "lrecon.sq",                                 
                                              "Linear"  = "lrecon",                                         
                                              "$\\times$ Protestant"     = "cathprotProtestant:lrecon",
                                              "$\\times$ prays rarely"   = "prayRarely:lrecon",
                                              "$\\times$ prays monthly"  = "prayMonthly:lrecon",
                                              "$\\times$ prays weekly"   = "prayWeekly:lrecon",                                    
                                              "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",                
                                              "$\\times$ technical"      = "oesch8Technical:lrecon",                    
                                              "$\\times$ management"     = "oesch8Management:lrecon",                   
                                              "$\\times$ clerks"         = "oesch8Clerks:lrecon",                       
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",               
                                              "$\\times$ service worker" = "oesch8Service worker:lrecon",               
                                              "$\\times$ primary sector" = "oesch8Primary sector:lrecon",                 
                                              "$\\times$ time" = "time:lrecon",          
                                              "$\\times$ Protestant     $\\times$ time" = "cathprotProtestant:time:lrecon",
                                              "$\\times$ prays rarely   $\\times$ time" = "prayRarely:time:lrecon",
                                              "$\\times$ prays monthly  $\\times$ time" = "prayMonthly:time:lrecon",
                                              "$\\times$ prays weekly   $\\times$ time" = "prayWeekly:time:lrecon",
                                              "$\\times$ prays daily    $\\times$ time" = "prayDaily:time:lrecon",
                                              "$\\times$ self-employed  $\\times$ time" = "time:oesch8Self-employed:lrecon",           
                                              "$\\times$ technical      $\\times$ time" = "time:oesch8Technical:lrecon",               
                                              "$\\times$ management     $\\times$ time" = "time:oesch8Management:lrecon",              
                                              "$\\times$ clerks         $\\times$ time" = "time:oesch8Clerks:lrecon",                  
                                              "$\\times$ socio-cultural $\\times$ time" = "time:oesch8Socio-cultural:lrecon",          
                                              "$\\times$ service worker $\\times$ time" = "time:oesch8Service worker:lrecon",          
                                              "$\\times$ primary sector $\\times$ time" = "time:oesch8Primary sector:lrecon")
                        )))


m_galtan


m_galtan |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="cathprot-context-galtan/mtable-cathprot-prayer-context-galtan.tex")




